"use client";

import {
  Card,
  CardContent,
  CardDescription,
  CardHeader,
  CardTitle,
} from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { CalendarIcon, ClockIcon, MapPinIcon } from "lucide-react";

interface ScheduleEntry {
  id: string;
  truckRegistration: string;
  route: string;
  departure: string;
  arrival: string;
  status: "on-time" | "delayed" | "completed";
}

export default function TruckSchedule() {
  const schedules: ScheduleEntry[] = [
    {
      id: "1",
      truckRegistration: "WA 12345",
      route: "Warszawa → Kraków",
      departure: "2025-11-01 08:00",
      arrival: "2025-11-01 12:00",
      status: "on-time",
    },
    {
      id: "2",
      truckRegistration: "KR 67890",
      route: "Gdańsk → Wrocław",
      departure: "2025-11-01 10:00",
      arrival: "2025-11-01 16:00",
      status: "delayed",
    },
    {
      id: "3",
      truckRegistration: "WA 12345",
      route: "Kraków → Poznań",
      departure: "2025-11-02 09:00",
      arrival: "2025-11-02 14:00",
      status: "on-time",
    },
    {
      id: "4",
      truckRegistration: "PO 11223",
      route: "Szczecin → Lublin",
      departure: "2025-10-30 07:00",
      arrival: "2025-10-30 15:00",
      status: "completed",
    },
  ];

  const getStatusColor = (status: string) => {
    switch (status) {
      case "on-time":
        return "bg-green-500/10 text-green-500 border-green-500/20";
      case "delayed":
        return "bg-yellow-500/10 text-yellow-500 border-yellow-500/20";
      case "completed":
        return "bg-blue-500/10 text-blue-500 border-blue-500/20";
      default:
        return "";
    }
  };

  return (
    <div className="space-y-6">
      <Card>
        <CardHeader>
          <CardTitle>Truck Harmonogram</CardTitle>
          <CardDescription>
            View scheduled routes for all trucks
          </CardDescription>
        </CardHeader>
        <CardContent>
          <div className="space-y-4">
            {schedules.map((schedule) => (
              <div
                key={schedule.id}
                className="rounded-lg border border-border bg-card p-4 transition-colors hover:bg-muted/50"
              >
                <div className="flex items-start justify-between mb-3">
                  <div>
                    <h3 className="font-semibold text-foreground">
                      {schedule.truckRegistration}
                    </h3>
                    <div className="flex items-center gap-2 mt-1 text-sm text-muted-foreground">
                      <MapPinIcon className="h-4 w-4" />
                      <span>{schedule.route}</span>
                    </div>
                  </div>
                  <Badge
                    className={getStatusColor(schedule.status)}
                    variant="outline"
                  >
                    {schedule.status}
                  </Badge>
                </div>
                <div className="grid grid-cols-2 gap-4 text-sm">
                  <div className="flex items-center gap-2 text-muted-foreground">
                    <CalendarIcon className="h-4 w-4" />
                    <div>
                      <p className="text-xs">Departure</p>
                      <p className="font-medium text-foreground">
                        {schedule.departure}
                      </p>
                    </div>
                  </div>
                  <div className="flex items-center gap-2 text-muted-foreground">
                    <ClockIcon className="h-4 w-4" />
                    <div>
                      <p className="text-xs">Arrival</p>
                      <p className="font-medium text-foreground">
                        {schedule.arrival}
                      </p>
                    </div>
                  </div>
                </div>
              </div>
            ))}
          </div>
        </CardContent>
      </Card>
    </div>
  );
}
