"use client";

import {
    Card,
    CardContent,
    CardDescription,
    CardHeader,
    CardTitle,
} from "@/components/ui/card";
import {Badge} from "@/components/ui/badge";
import {MapIcon, RouteIcon} from "lucide-react";
import {useContext} from "react";
import {APIProvider, Map} from '@vis.gl/react-google-maps';
import type {MapCameraChangedEvent} from "@vis.gl/react-google-maps";

interface Route {
    id: string;
    name: string;
    distance: string;
    duration: string;
    cities: string[];
    difficulty: "easy" | "medium" | "hard";
}

export default function RouteMap() {
    const routes: Route[] = [
        {
            id: "1",
            name: "A1 Highway Route",
            distance: "580 km",
            duration: "6h 30m",
            cities: ["Gdańsk", "Toruń", "Łódź", "Częstochowa", "Katowice"],
            difficulty: "easy",
        },
        {
            id: "2",
            name: "A2 East-West Corridor",
            distance: "620 km",
            duration: "7h 00m",
            cities: ["Warszawa", "Łódź", "Poznań", "Świecko"],
            difficulty: "easy",
        },
        {
            id: "3",
            name: "A4 Southern Route",
            distance: "670 km",
            duration: "7h 30m",
            cities: ["Zgorzelec", "Wrocław", "Katowice", "Kraków", "Rzeszów"],
            difficulty: "medium",
        },
        {
            id: "4",
            name: "S7 North-South",
            distance: "710 km",
            duration: "8h 30m",
            cities: ["Gdańsk", "Elbląg", "Warszawa", "Kielce", "Kraków"],
            difficulty: "medium",
        },
        {
            id: "5",
            name: "Eastern Border Route",
            distance: "450 km",
            duration: "6h 00m",
            cities: ["Białystok", "Lublin", "Rzeszów"],
            difficulty: "hard",
        },
        {
            id: "6",
            name: "Western Corridor",
            distance: "520 km",
            duration: "6h 30m",
            cities: ["Szczecin", "Gorzów Wielkopolski", "Zielona Góra", "Wrocław"],
            difficulty: "medium",
        },
    ];

    const getDifficultyColor = (difficulty: string) => {
        switch (difficulty) {
            case "easy":
                return "bg-green-500/10 text-green-500 border-green-500/20";
            case "medium":
                return "bg-yellow-500/10 text-yellow-500 border-yellow-500/20";
            case "hard":
                return "bg-red-500/10 text-red-500 border-red-500/20";
            default:
                return "";
        }
    };

    return (
        <div className="space-y-6">
            <div>
                <h2 className="text-2xl font-bold text-foreground">Polish Route Map</h2>
                <p className="text-sm text-muted-foreground">
                    Available truck routes across Poland
                </p>
            </div>

            <Card className="bg-muted/30 h-200px">
                <CardContent className="p-6 h-full w-full">
                    <APIProvider apiKey={'AIzaSyB6byOXlhB6hPsitkoHHV9ZfsrSqaBY4QA'}
                                 onLoad={() => console.log('Maps API has loaded.')}>
                        <div className="h-screen w-full">
                            <Map
                                defaultCenter={{ lat: 52, lng: 20 }}
                                defaultZoom={6}
                                gestureHandling="greedy"
                                disableDefaultUI={false}
                            />
                        </div>
                    </APIProvider>
                </CardContent>
            </Card>

            <div className="grid gap-4 md:grid-cols-2 lg:grid-cols-3">
                {routes.map((route) => (
                    <Card key={route.id} className="transition-colors hover:bg-muted/50">
                        <CardHeader>
                            <div className="flex items-start justify-between">
                                <div className="flex items-center gap-2">
                                    <RouteIcon className="h-5 w-5 text-primary"/>
                                    <CardTitle className="text-base">{route.name}</CardTitle>
                                </div>
                                <Badge
                                    className={getDifficultyColor(route.difficulty)}
                                    variant="outline"
                                >
                                    {route.difficulty}
                                </Badge>
                            </div>
                            <CardDescription>
                                {route.distance} • {route.duration}
                            </CardDescription>
                        </CardHeader>
                        <CardContent>
                            <div className="space-y-2">
                                <p className="text-xs font-medium text-muted-foreground">
                                    Route Cities:
                                </p>
                                <div className="flex flex-wrap gap-1">
                                    {route.cities.map((city, index) => (
                                        <Badge key={index} variant="secondary" className="text-xs">
                                            {city}
                                        </Badge>
                                    ))}
                                </div>
                            </div>
                        </CardContent>
                    </Card>
                ))}
            </div>
        </div>
    );
}
