"use client";

import {useState} from "react";
import {Tabs, TabsContent, TabsList, TabsTrigger} from "@/components/ui/tabs";
import {TruckIcon, MapIcon} from "lucide-react";
import FleetManagement from "@/components/fleet-management";
import RouteMap from "@/components/route-map";
import {Dashboard} from "@/components/Dashboard.tsx";

export default function TruckManagementApp() {
    const [activeTab, setActiveTab] = useState("fleet");

    return (
        <div className="min-h-screen bg-background">
            <header className="border-b border-border bg-card">
                <div className="container mx-auto px-4 py-4">
                    <div className="flex items-center justify-between">
                        <div className="flex items-center gap-3">
                            <div className="flex h-10 w-10 items-center justify-center rounded-lg bg-primary">
                                <TruckIcon className="h-6 w-6 text-primary-foreground"/>
                            </div>
                            <div>
                                <h1 className="text-xl font-bold text-foreground">
                                    FleetTrack
                                </h1>
                                <p className="text-xs text-muted-foreground">
                                    Logistics Platform
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </header>

            <main className="container mx-auto px-4 py-6">
                <Dashboard/>
            </main>
        </div>
    );
}
