extends Node

var current_encounter: Encounter
var current_charachter: Entity
var current_index = 0

func _ready() -> void:
	Events.start_combat.connect(start_combat)
	
func start_combat(encounter: Encounter):
	current_index = 0
	current_encounter = encounter
	current_charachter = encounter.enemies[current_index]
	Events.current_charachter_changed.emit(current_charachter)

func set_current_charachter(entity: Entity):
	self.current_charachter = entity
	Events.current_charachter_changed.emit(entity)

func get_next_entity() -> Entity:
	var next_index = current_index + 1
	if next_index >= len(current_encounter.enemies):
		return null
	return current_encounter.enemies[next_index]

func start_next_turn():
	current_charachter = get_next_entity()
	if get_next_entity() == null:
		current_index = 0
		set_current_charachter(self.current_encounter.enemies[current_index])
		return
	current_index += 1
	set_current_charachter(current_charachter)
